/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.soap;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SOAPUtility {
    private static Logger logger = Logger.getLogger("filenet.pe.soap");
    private static String m_className = "SOAPUtility";

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:46:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] ObjectToBytes(String rpc, Object obj) throws VWException {
        byte[] byArray;
        String m_method = "ObjectToBytes:" + rpc;
        if (obj == null) {
            return null;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Object class=" + obj.getClass().getName());
        }
        ObjectOutputStream objOs = null;
        try {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                objOs = new ObjectOutputStream(new BufferedOutputStream(byteStream));
                objOs.writeObject(obj);
                objOs.flush();
                byArray = byteStream.toByteArray();
                Object var7_7 = null;
                if (objOs == null) return byArray;
            }
            catch (IOException e) {
                logger.throwing(m_className, m_method, e);
                throw new VWException("filenet.pe.soap.SOAPClientSession.ToBytesError", "RPC {0}. IO Error while serialize objects to bytes. {1}:{2}", rpc, e.getClass().getName(), e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (objOs == null) throw throwable;
            try {
                objOs.close();
                objOs = null;
                throw throwable;
            }
            catch (Exception ex) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ex) {
            // empty catch block
            return byArray;
        }
        objOs.close();
        return byArray;
    }

    public static final Object BytesToObject(String rpc, byte[] bytes) throws VWException {
        String m_method = "BytesToObject:" + rpc;
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objIs = new ObjectInputStream(new BufferedInputStream(byteStream));
            return objIs.readObject();
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("filenet.pe.soap.SOAPClientSession.FromBytesError", "RPC {0}. IO Error while deserializing bytes to object. {1}:{2}", rpc, e.getClass().getName(), e.getMessage());
        }
    }
}

